/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.sys;

import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.fsp.AsyncEventHandler;
import com.ibm.hsc.fsp.AsyncEventListener;
import com.ibm.hsc.fsp.FspSvrAsyncSubscription;
import com.ibm.hsc.fsp.cmdhelpers.FspErrorLogId;
import com.ibm.hsc.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.objmgr.sys.OmSysMgr;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;

public abstract class OmSysAsyncEvtHandler
implements AsyncEventHandler {
    protected OmSysMgr mSysMgr;
    protected AsyncEventListener mAsyncListener;
    protected Hashtable mSvrEvtSubscriptions = new Hashtable();
    protected static final int FSP_EVENT_TARGET = 28672;
    protected static final int FSP_EVENT_OPCODE = 1;
    protected static final String FSP_ASYNC_EVENT = "ASYNC_EVENT_NOTIFICATION";
    protected static final String FSP_EVENT_MASK_LENGTH = "MASK_LENGTH";
    protected static final String FSP_EVENT_MASK_DATA = "DATA";
    protected static final String HYPER_PIPE_RESP_ASYNC = "HYPER_PIPE_RESP_ASYNC";
    protected static final String HYPER_PIPE_RESP_ASYNC_EXCH_CAPS = "HYPER_PIPE_RESP_ASYNC_EXCH_CAPS";
    protected static final byte[] FSP_EVENT_REG_MASK = new byte[]{123, -43, 24, 0};
    protected static final int FSP_BROADCAST_EVT_BIT = 1;
    protected static final int FSP_CEC_STATE_CHANGE_EVT_BIT = 2;
    protected static final int FSP_PHYP_STATE_CHANGE_EVT_BIT = 3;
    protected static final int FSP_TAKEOVER_EVT_BIT = 4;
    protected static final int FSP_PFT_EVT_LOG_EVT_BIT = 6;
    protected static final int FSP_PFT_DUMP_EVT_BIT = 7;
    protected static final int FSP_NEW_SRC_EVT_BIT = 8;
    protected static final int FSP_LOCK_CHANGE_EVT_BIT = 9;
    protected static final int FSP_SMA_EVT_BIT = 11;
    protected static final int FSP_SAVE_AREA_CHANGE_EVT_BIT = 13;
    protected static final int FSP_VTERM_AVL_EVT_BIT = 15;
    protected static final int FSP_CEC_NAME_CHANGE_EVT_BIT = 19;
    protected static final int FSP_SYS_ATTN_CHANGE_EVT_BIT = 20;

    public OmSysAsyncEvtHandler(OmSysMgr omSysMgr) {
        this.mSysMgr = omSysMgr;
        System.out.println("Create the async event listener");
        this.mAsyncListener = new AsyncEventListener(this);
        try {
            System.out.println("init the async event listener");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void subscribe(FspSvrAsyncSubscription fspSvrAsyncSubscription) {
        Integer n = new Integer(fspSvrAsyncSubscription.getEventType());
        Vector<FspSvrAsyncSubscription> vector = (Vector<FspSvrAsyncSubscription>)this.mSvrEvtSubscriptions.get(n);
        if (vector == null) {
            vector = new Vector<FspSvrAsyncSubscription>();
            this.mSvrEvtSubscriptions.put(n, vector);
        }
        System.out.println("Add new svr subscription: " + fspSvrAsyncSubscription);
        vector.addElement(fspSvrAsyncSubscription);
    }

    public void unsubscribe(FspSvrAsyncSubscription fspSvrAsyncSubscription) {
        System.out.println("unsubscribe " + fspSvrAsyncSubscription);
        Integer n = new Integer(fspSvrAsyncSubscription.getEventType());
        Vector vector = (Vector)this.mSvrEvtSubscriptions.get(n);
        if (vector == null || vector.size() < 1) {
            System.out.println("cannot find svr subs for evt: " + n);
        }
        vector.remove(fspSvrAsyncSubscription);
    }

    public void clearServerEventSubscriptions() {
        Enumeration enumeration = this.mSvrEvtSubscriptions.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            for (int i = 0; i < vector.size(); ++i) {
                FspSvrAsyncSubscription fspSvrAsyncSubscription = (FspSvrAsyncSubscription)vector.elementAt(i);
                fspSvrAsyncSubscription.close();
            }
        }
    }

    protected void handSvrEvtSubs(int n, byte[] byArray) {
        Integer n2 = new Integer(n);
        Vector vector = (Vector)this.mSvrEvtSubscriptions.get(n2);
        if (vector == null || vector.size() < 1) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            FspSvrAsyncSubscription fspSvrAsyncSubscription = (FspSvrAsyncSubscription)vector.elementAt(i);
            fspSvrAsyncSubscription.addEvent(byArray);
        }
    }

    public abstract void reinitialize();

    public void stopListener() {
        this.mAsyncListener.close();
    }

    public AsyncEventListener getAsyncListener() {
        return this.mAsyncListener;
    }

    public abstract void handleEvent(int var1, byte[] var2, byte[] var3, byte[] var4);

    protected void handlePlatformLogEvent(byte[] byArray) {
        int n = HardwareServerMessage.bytesToUInt(byArray, 0);
        String string = this.mSysMgr.getCmdMgr().getLocationCodeByVport(n);
        try {
            FspErrorLogId fspErrorLogId = this.mSysMgr.getCmdHelper().getCurrentFspLogEntryId(new UnsignedInt16(61440), string);
            Long l = new Long(fspErrorLogId.getLogEntryId().longValue());
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(l);
            vector.addElement(string);
            HSCEventIndicationMgr.getInstance().sendIndication(301, this.mSysMgr.getObject(), vector);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void handlePlatformDumpEvent(byte[] byArray) {
        int n = HardwareServerMessage.bytesToUInt(byArray, 0);
        String string = this.mSysMgr.getCmdMgr().getLocationCodeByVport(n);
        HSCEventIndicationMgr.getInstance().sendIndication(302, this.mSysMgr.getObject(), string);
    }

    protected void acknowledgeFspEvent() {
        try {
            this.mSysMgr.getCmdHelper().acknowledgeOutstandingEvents();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

